load('resmatrix3p025.mat') 
%% plots with contour
%param
pt = 0.7;
ptsd = 0.7;
ptsm = 0.7/sqrt(17);
pu = 0.42;
pusd = 0.12;
pusm = 0.12/sqrt(17);
pa = 0.38;
pasd = 0.26;
pasm = 0.26/sqrt(17);


[X,Y] = meshgrid(0:0.1:1);
[Xq,Yq] = meshgrid(0:0.01:1);
XX = 0:0.01:1;
f1 = fspecial('Gaussian',5,1);
S1= imfilter(RES1b,f1,'replicate');
S2= imfilter(1./RES2,f1,'replicate');
S3= imfilter(RES3,f1,'replicate');
V1q = interp2(X,Y,S1,Xq,Yq);
V1f = rot90(V1q.*5./60);
V2q = interp2(X,Y,S2,Xq,Yq);
V2f = rot90(V2q);
V3q = interp2(X,Y,S3,Xq,Yq);
V3f = rot90(V3q);
figure(1)
imagesc(XX,XX,V1f,[0 4.5])%,[],'initialmagnification',5000);colormap('jet');colorbar;set(gca,'FontSize',24,'fontweight','bold')
colormap('jet');colorbar;set(gca,'FontSize',24,'fontweight','bold')
hold on
% alignement
v = [pa,pa];
contour(Xq,Yq,V3f,v,'y','linewidth',3)
v = [pa+pasm,pa+pasm];
contour(Xq,Yq,V3f,v,'y--','linewidth',1)
v = [pa-pasm,pa-pasm];
contour(Xq,Yq,V3f,v,'y--','linewidth',1)
% unicity
v = [pu,pu];
contour(Xq,Yq,V2f,v,'c','linewidth',3)
v = [pu+pusm,pu+pusm];
contour(Xq,Yq,V2f,v,'c--','linewidth',1)
v = [pu-pusm,pu-pusm];
contour(Xq,Yq,V2f,v,'c--','linewidth',1)
% persistence time
v = [pt,pt];
contour(Xq,Yq,V1f,v,'w','linewidth',3)
v = [pt+ptsm,pt+ptsm];
contour(Xq,Yq,V1f,v,'w--','linewidth',1)
v = [pt-ptsm,pt-ptsm];
contour(Xq,Yq,V1f,v,'w--','linewidth',1)


yticks([0 0.5 1]);
yticklabels({'1','0.5','0'})
 saveas(gcf,'WTvsHeLa.png')

%%
figure(2)
imagesc(XX,XX,V2f)%,[],'initialmagnification',5000);colormap('jet');colorbar;set(gca,'FontSize',24,'fontweight','bold')
colormap('jet');colorbar;set(gca,'FontSize',24,'fontweight','bold')
hold on
v = [0.63,0.63];
contour(Xq,Yq,V2f,v,'g','linewidth',3)
v = [0.63+0.12,0.63+0.12];
contour(Xq,Yq,V2f,v,'g','linewidth',1)
v = [0.63-0.12,0.63-0.12];
contour(Xq,Yq,V2f,v,'g','linewidth',1)

figure(3)
imagesc(XX,XX,V3f)%,[],'initialmagnification',5000);colormap('jet');colorbar;set(gca,'FontSize',24,'fontweight','bold')
colormap('jet');colorbar;set(gca,'FontSize',24,'fontweight','bold')
hold on
% alignement
v = [0.72,0.72];
contour(Xq,Yq,V3f,v,'w','linewidth',3)
v = [0.72+0.21,0.72+0.21];
contour(Xq,Yq,V3f,v,'w','linewidth',1)
v = [0.72-0.21,0.72-0.21];
contour(Xq,Yq,V3f,v,'w','linewidth',1)
